<!DOCTYPE html>
<html lang="en" class="dark bg-gray-900">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e($settings->site_name ?? config('app.name')); ?></title>

    <!-- Favicon -->
    <?php if(isset($settings) && $settings->favicon): ?>
        <link href="<?php echo e(asset('storage/app/public/'.$settings->favicon)); ?>" rel="icon" type="image/x-icon" />
    <?php endif; ?>

    <!-- Inter Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            200: '#c7d2fe',
                            300: '#a5b4fc',
                            400: '#818cf8',
                            500: '#6366f1',
                            600: '#4f46e5',
                            700: '#4338ca',
                            800: '#3730a3',
                            900: '#312e81',
                        },
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'pulse-slow': 'pulse 3s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                        'fade-in-up': 'fadeInUp 0.6s ease-out',
                        'fade-in': 'fadeIn 0.8s ease-out',
                        'slide-in-left': 'slideInLeft 0.8s ease-out',
                        'slide-in-right': 'slideInRight 0.8s ease-out',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': { transform: 'translateY(0px)' },
                            '50%': { transform: 'translateY(-20px)' },
                        },
                        fadeInUp: {
                            '0%': { opacity: '0', transform: 'translateY(30px)' },
                            '100%': { opacity: '1', transform: 'translateY(0)' },
                        },
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' },
                        },
                        slideInLeft: {
                            '0%': { opacity: '0', transform: 'translateX(-50px)' },
                            '100%': { opacity: '1', transform: 'translateX(0)' },
                        },
                        slideInRight: {
                            '0%': { opacity: '0', transform: 'translateX(50px)' },
                            '100%': { opacity: '1', transform: 'translateX(0)' },
                        },
                    },
                }
            }
        }
    </script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <style>
        [x-cloak] { display: none !important; }
        body {
            background-image:
                radial-gradient(at 40% 20%, hsla(228, 100%, 74%, 0.1) 0px, transparent 50%),
                radial-gradient(at 80% 0%, hsla(189, 100%, 56%, 0.1) 0px, transparent 50%),
                radial-gradient(at 0% 50%, hsla(355, 100%, 93%, 0.1) 0px, transparent 50%),
                radial-gradient(at 80% 50%, hsla(340, 100%, 76%, 0.1) 0px, transparent 50%),
                radial-gradient(at 0% 100%, hsla(22, 100%, 77%, 0.1) 0px, transparent 50%),
                radial-gradient(at 80% 100%, hsla(242, 100%, 70%, 0.1) 0px, transparent 50%),
                radial-gradient(at 0% 0%, hsla(343, 100%, 76%, 0.1) 0px, transparent 50%);
        }
        .glass-effect {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        .floating-shapes {
            position: absolute;
            inset: 0;
            overflow: hidden;
            pointer-events: none;
        }
        .floating-shape {
            position: absolute;
            opacity: 0.1;
            animation: float 8s ease-in-out infinite;
        }
        .floating-shape:nth-child(2) { animation-delay: -2s; }
        .floating-shape:nth-child(3) { animation-delay: -4s; }
        .floating-shape:nth-child(4) { animation-delay: -6s; }
    </style>
</head>

<body class="dark text-gray-100 bg-gray-900 min-h-screen font-sans overflow-hidden">
    <!-- Floating Background Shapes -->
    <div class="floating-shapes">
        <div class="floating-shape w-64 h-64 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full blur-3xl top-1/4 left-1/4"></div>
        <div class="floating-shape w-48 h-48 bg-gradient-to-r from-indigo-500 to-cyan-500 rounded-full blur-3xl top-3/4 right-1/4"></div>
        <div class="floating-shape w-32 h-32 bg-gradient-to-r from-pink-500 to-rose-500 rounded-full blur-3xl top-1/2 left-3/4"></div>
        <div class="floating-shape w-56 h-56 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-full blur-3xl bottom-1/4 left-1/2"></div>
    </div>

    <!-- Main Container -->
    <div class="flex min-h-screen">
        <!-- Left Side - Content -->
        <div class="w-full lg:w-1/2 flex items-center justify-center p-8 lg:p-12 relative z-10">
            <div class="max-w-lg w-full animate-slide-in-left">
                <!-- Logo -->
                <?php if(isset($settings) && $settings->logo): ?>
                <div class="flex justify-center lg:justify-start mb-8">
                    <div class="relative">
                        <img src="<?php echo e(asset('storage/app/public/'.$settings->logo)); ?>"
                             class="h-12 w-auto brightness-110"
                             alt="<?php echo e($settings->site_name ?? config('app.name')); ?>" />
                        <div class="absolute inset-0 bg-gradient-to-r from-blue-500/20 to-indigo-500/20 rounded-lg blur-xl"></div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Error Code -->
                <div class="text-center lg:text-left mb-8">
                    <div class="text-8xl lg:text-9xl font-black text-transparent bg-clip-text bg-gradient-to-r from-red-400 via-pink-400 to-purple-400 mb-4 tracking-tight leading-none">
                        <?php echo $__env->yieldContent('code', 'Oh no'); ?>
                    </div>

                    <div class="w-16 h-1 bg-gradient-to-r from-purple-500 to-pink-500 my-6 mx-auto lg:mx-0"></div>

                    <p class="text-gray-300 text-xl lg:text-2xl font-light leading-relaxed mb-8">
                        <?php echo $__env->yieldContent('message', "We're experiencing some technical difficulties."); ?>
                    </p>
                </div>

                <!-- Action Buttons -->
                <div class="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start">
                    <a href="<?php echo e(app('router')->has('home') ? route('home') : url('/')); ?>"
                       class="group inline-flex items-center justify-center gap-3 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-semibold px-8 py-4 rounded-2xl transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/25 focus:outline-none focus:ring-4 focus:ring-blue-500/20">
                        <i data-lucide="home" class="w-5 h-5 group-hover:scale-110 transition-transform"></i>
                        <span>Go Home</span>
                    </a>

                    <button onclick="window.history.back()"
                            class="group inline-flex items-center justify-center gap-3 bg-gray-800/80 hover:bg-gray-700/80 border border-gray-600 hover:border-gray-500 text-gray-200 hover:text-white font-semibold px-8 py-4 rounded-2xl transition-all duration-300 transform hover:-translate-y-1 hover:shadow-xl focus:outline-none focus:ring-4 focus:ring-gray-500/20">
                        <i data-lucide="arrow-left" class="w-5 h-5 group-hover:-translate-x-1 transition-transform"></i>
                        <span>Go Back</span>
                    </button>
                </div>

                <!-- Additional Help Links -->
                <div class="mt-12 pt-8 border-t border-gray-700/50 text-center lg:text-left">
                    <p class="text-gray-400 text-sm mb-4">Need assistance?</p>
                    <div class="flex flex-wrap justify-center lg:justify-start gap-6 text-sm">
                        <a href="<?php echo e(url('/')); ?>" class="text-blue-400 hover:text-blue-300 transition-colors inline-flex items-center gap-2">
                            <i data-lucide="help-circle" class="w-4 h-4"></i>
                            Support
                        </a>
                        <a href="<?php echo e(url('/')); ?>" class="text-blue-400 hover:text-blue-300 transition-colors inline-flex items-center gap-2">
                            <i data-lucide="message-circle" class="w-4 h-4"></i>
                            Contact
                        </a>
                        <a href="<?php echo e(url('/')); ?>" class="text-blue-400 hover:text-blue-300 transition-colors inline-flex items-center gap-2">
                            <i data-lucide="book-open" class="w-4 h-4"></i>
                            Docs
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Side - Illustration -->
        <div class="hidden lg:flex lg:w-1/2 items-center justify-center p-12 relative">
            <div class="animate-slide-in-right w-full max-w-lg">
                <!-- Error Illustration Container -->
                <div class="relative">
                    <!-- Main Illustration Area -->
                    <div class="glass-effect rounded-3xl p-12 text-center">
                        <?php if (! empty(trim($__env->yieldContent('image')))): ?>
                            <?php echo $__env->yieldContent('image'); ?>
                        <?php else: ?>
                            <!-- Default Illustration -->
                            <div class="relative">
                                <!-- Floating Error Icon -->
                                <div class="inline-flex items-center justify-center w-48 h-48 rounded-full bg-gradient-to-br from-red-500/20 to-pink-500/20 border border-red-500/30 mb-8 animate-float">
                                    <?php if(View::hasSection('code') && trim(View::getSection('code')) == '404'): ?>
                                        <i data-lucide="search-x" class="w-24 h-24 text-red-400"></i>
                                    <?php elseif(View::hasSection('code') && trim(View::getSection('code')) == '419'): ?>
                                        <i data-lucide="clock" class="w-24 h-24 text-yellow-400"></i>
                                    <?php elseif(View::hasSection('code') && trim(View::getSection('code')) == '500'): ?>
                                        <i data-lucide="server-crash" class="w-24 h-24 text-red-400"></i>
                                    <?php elseif(View::hasSection('code') && trim(View::getSection('code')) == '403'): ?>
                                        <i data-lucide="shield-x" class="w-24 h-24 text-orange-400"></i>
                                    <?php else: ?>
                                        <i data-lucide="alert-triangle" class="w-24 h-24 text-red-400"></i>
                                    <?php endif; ?>
                                </div>

                                <!-- Decorative Elements -->
                                <div class="absolute -top-4 -right-4 w-8 h-8 bg-blue-500 rounded-full animate-pulse opacity-60"></div>
                                <div class="absolute -bottom-4 -left-4 w-6 h-6 bg-purple-500 rounded-full animate-pulse opacity-40" style="animation-delay: 1s;"></div>
                                <div class="absolute top-1/2 -left-8 w-4 h-4 bg-cyan-500 rounded-full animate-pulse opacity-50" style="animation-delay: 2s;"></div>

                                <!-- Circuit Lines -->
                                <div class="absolute inset-0 pointer-events-none">
                                    <svg class="w-full h-full opacity-20" viewBox="0 0 200 200">
                                        <path d="M20,100 Q100,20 180,100" stroke="url(#gradient1)" stroke-width="2" fill="none" class="animate-pulse">
                                            <animate attributeName="stroke-dasharray" values="0,1000;1000,0;0,1000" dur="3s" repeatCount="indefinite"/>
                                        </path>
                                        <path d="M100,20 Q180,100 100,180" stroke="url(#gradient2)" stroke-width="2" fill="none" class="animate-pulse" style="animation-delay: 1s;">
                                            <animate attributeName="stroke-dasharray" values="0,1000;1000,0;0,1000" dur="3s" repeatCount="indefinite"/>
                                        </path>
                                        <defs>
                                            <linearGradient id="gradient1" x1="0%" y1="0%" x2="100%" y2="100%">
                                                <stop offset="0%" style="stop-color:#3B82F6;stop-opacity:0.6" />
                                                <stop offset="100%" style="stop-color:#8B5CF6;stop-opacity:0.6" />
                                            </linearGradient>
                                            <linearGradient id="gradient2" x1="0%" y1="0%" x2="100%" y2="100%">
                                                <stop offset="0%" style="stop-color:#10B981;stop-opacity:0.6" />
                                                <stop offset="100%" style="stop-color:#06B6D4;stop-opacity:0.6" />
                                            </linearGradient>
                                        </defs>
                                    </svg>
                                </div>
                            </div>

                            <!-- Status Message -->
                            <div class="mt-8">
                                <p class="text-gray-300 text-lg font-medium mb-4">System Status</p>
                                <div class="flex items-center justify-center gap-3 text-sm">
                                    <div class="flex items-center gap-2">
                                        <div class="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
                                        <span class="text-gray-400">Monitoring</span>
                                    </div>
                                    <div class="w-px h-4 bg-gray-600"></div>
                                    <div class="flex items-center gap-2">
                                        <i data-lucide="shield-check" class="w-3 h-3 text-green-400"></i>
                                        <span class="text-gray-400">Secure</span>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Glow Effect -->
                    <div class="absolute inset-0 bg-gradient-to-r from-blue-500/10 to-purple-500/10 rounded-3xl blur-xl -z-10"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="absolute bottom-4 left-0 right-0 text-center text-gray-500 text-sm z-10">
        <p>&copy; <?php echo e(date('Y')); ?> <?php echo e($settings->site_name ?? config('app.name')); ?>. All rights reserved.</p>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Lucide icons
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }

            // Keyboard navigation
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    window.history.back();
                } else if (e.key === 'Home') {
                    window.location.href = '/';
                }
            });
        });
    </script>

    <!-- CSRF Token Auto-Refresh Script -->
    <script src="<?php echo e(asset('js/csrf-token-refresh.js')); ?>"></script>
</body>
</html>
<?php /**PATH /home2/caltrixd/public_html/resources/views/errors/illustrated-layout.blade.php ENDPATH**/ ?>