<?php $__env->startSection('title', 'Session Expired'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-900 relative overflow-hidden">
    <div class="relative z-10 flex min-h-screen items-center justify-center px-4 py-8 sm:px-6 lg:px-8">
        <div class="w-full max-w-lg">
            <div class="relative bg-gray-900 border border-gray-700 rounded-3xl p-8 sm:p-10 shadow-2xl text-center">
                <!-- Icon -->
                <div class="flex items-center justify-center mb-6">
                    <div class="relative">
                        <div class="h-20 w-20 bg-gradient-to-br from-yellow-400 to-orange-500 rounded-full flex items-center justify-center">
                            <i data-lucide="clock" class="h-10 w-10 text-white"></i>
                        </div>
                    </div>
                </div>

                <!-- Title -->
                <h1 class="text-2xl sm:text-3xl font-bold text-white mb-4">
                    Session Expired
                </h1>

                <!-- Message -->
                <div class="space-y-4 mb-8">
                    <p class="text-gray-300 text-sm sm:text-base leading-relaxed">
                        Your session has expired for security reasons. This happens when you stay on the page for an extended period without activity.
                    </p>

                    <div class="bg-blue-500/10 border border-blue-400/20 rounded-2xl p-4">
                        <div class="flex items-start gap-3">
                            <i data-lucide="info" class="h-5 w-5 text-blue-400 flex-shrink-0 mt-0.5"></i>
                            <div class="text-left">
                                <p class="text-blue-100 text-sm font-medium mb-2">Why did this happen?</p>
                                <ul class="text-blue-200 text-xs space-y-1">
                                    <li>• You've been inactive for more than 2 hours</li>
                                    <li>• This protects your account from unauthorized access</li>
                                    <li>• Your data remains secure and unchanged</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="space-y-4">
                    <button onclick="window.history.back()"
                            class="group relative flex w-full justify-center items-center gap-3 rounded-2xl bg-gradient-to-r from-blue-500 to-cyan-500 hover:from-blue-600 hover:to-cyan-600 px-6 py-4 text-base font-bold text-white transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                        <i data-lucide="arrow-left" class="h-5 w-5"></i>
                        <span>Go Back & Try Again</span>
                    </button>

                    <button onclick="window.location.href='<?php echo e(route('login')); ?>'"
                            class="group relative flex w-full justify-center items-center gap-3 rounded-2xl border border-gray-600 bg-gray-800 hover:bg-gray-700 hover:border-blue-400/50 px-6 py-4 text-base font-semibold text-gray-300 hover:text-white transition-all duration-200">
                        <i data-lucide="log-in" class="h-5 w-5"></i>
                        <span>Login Again</span>
                    </button>

                    <button onclick="window.location.href='<?php echo e(url('/')); ?>'"
                            class="group relative flex w-full justify-center items-center gap-3 rounded-2xl border border-gray-600 bg-gray-800 hover:bg-gray-700 hover:border-green-400/50 px-6 py-4 text-base font-semibold text-gray-300 hover:text-white transition-all duration-200">
                        <i data-lucide="home" class="h-5 w-5"></i>
                        <span>Go to Homepage</span>
                    </button>
                </div>

                <!-- Security Notice -->
                <div class="mt-8 pt-6 border-t border-gray-700">
                    <div class="flex items-center justify-center gap-6 text-xs text-gray-400">
                        <div class="flex items-center gap-1">
                            <i data-lucide="shield-check" class="w-3 h-3 text-green-400"></i>
                            <span>Secure</span>
                        </div>
                        <div class="flex items-center gap-1">
                            <i data-lucide="lock" class="w-3 h-3 text-blue-400"></i>
                            <span>Protected</span>
                        </div>
                        <div class="flex items-center gap-1">
                            <i data-lucide="clock" class="w-3 h-3 text-cyan-400"></i>
                            <span>Auto-Refresh Enabled</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Lucide icons
        if (typeof lucide !== 'undefined') {
            lucide.createIcons();
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\captcha\resources\views/errors/419.blade.php ENDPATH**/ ?>