
<!DOCTYPE html>
<html lang="en" class="dark bg-gray-900">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title') - {{ $settings->site_name ?? config('app.name') }}</title>

    <!-- Favicon -->
    @if(isset($settings) && $settings->favicon)
        <link href="{{ asset('storage/app/public/'.$settings->favicon)}}" rel="icon" type="image/x-icon" />
    @endif

    <!-- Inter Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            200: '#c7d2fe',
                            300: '#a5b4fc',
                            400: '#818cf8',
                            500: '#6366f1',
                            600: '#4f46e5',
                            700: '#4338ca',
                            800: '#3730a3',
                            900: '#312e81',
                        },
                        'glass': 'rgba(255, 255, 255, 0.05)',
                    },
                    backdropBlur: {
                        'xs': '2px',
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'pulse-slow': 'pulse 3s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                        'fade-in-up': 'fadeInUp 0.6s ease-out',
                        'fade-in': 'fadeIn 0.8s ease-out',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': { transform: 'translateY(0px)' },
                            '50%': { transform: 'translateY(-20px)' },
                        },
                        fadeInUp: {
                            '0%': { opacity: '0', transform: 'translateY(30px)' },
                            '100%': { opacity: '1', transform: 'translateY(0)' },
                        },
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' },
                        },
                    },
                }
            }
        }
    </script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <style>
        [x-cloak] { display: none !important; }
        body {
            background-image:
                radial-gradient(at 40% 20%, hsla(228, 100%, 74%, 0.1) 0px, transparent 50%),
                radial-gradient(at 80% 0%, hsla(189, 100%, 56%, 0.1) 0px, transparent 50%),
                radial-gradient(at 0% 50%, hsla(355, 100%, 93%, 0.1) 0px, transparent 50%),
                radial-gradient(at 80% 50%, hsla(340, 100%, 76%, 0.1) 0px, transparent 50%),
                radial-gradient(at 0% 100%, hsla(22, 100%, 77%, 0.1) 0px, transparent 50%),
                radial-gradient(at 80% 100%, hsla(242, 100%, 70%, 0.1) 0px, transparent 50%),
                radial-gradient(at 0% 0%, hsla(343, 100%, 76%, 0.1) 0px, transparent 50%);
        }
        .glass-effect {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        .error-glow {
            box-shadow: 0 0 60px rgba(59, 130, 246, 0.3);
        }
        .floating-shapes {
            position: absolute;
            inset: 0;
            overflow: hidden;
            pointer-events: none;
        }
        .floating-shape {
            position: absolute;
            opacity: 0.1;
            animation: float 8s ease-in-out infinite;
        }
        .floating-shape:nth-child(2) { animation-delay: -2s; }
        .floating-shape:nth-child(3) { animation-delay: -4s; }
        .floating-shape:nth-child(4) { animation-delay: -6s; }
    </style>
</head>

<body class="dark text-gray-100 bg-gray-900 min-h-screen flex items-center justify-center p-4 font-sans">
    <!-- Floating Background Shapes -->
    <div class="floating-shapes">
        <div class="floating-shape w-64 h-64 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full blur-3xl top-1/4 left-1/4"></div>
        <div class="floating-shape w-48 h-48 bg-gradient-to-r from-indigo-500 to-cyan-500 rounded-full blur-3xl top-3/4 right-1/4"></div>
        <div class="floating-shape w-32 h-32 bg-gradient-to-r from-pink-500 to-rose-500 rounded-full blur-3xl top-1/2 left-3/4"></div>
        <div class="floating-shape w-56 h-56 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-full blur-3xl bottom-1/4 left-1/2"></div>
    </div>

    <!-- Main Error Container -->
    <div class="relative z-10 w-full max-w-2xl">
        <!-- Logo Section -->
        @if(isset($settings) && $settings->logo)
        <div class="flex justify-center mb-8 animate-fade-in">
            <div class="relative">
                <img src="{{ asset('storage/app/public/'.$settings->logo)}}"
                     class="h-12 w-auto brightness-110"
                     alt="{{ $settings->site_name ?? config('app.name') }}" />
                <div class="absolute inset-0 bg-gradient-to-r from-blue-500/20 to-indigo-500/20 rounded-lg blur-xl"></div>
            </div>
        </div>
        @endif

        <!-- Error Card -->
        <div class="glass-effect rounded-3xl p-8 md:p-12 text-center animate-fade-in-up error-glow">
            <!-- Error Code -->
            <div class="mb-8">
                <div class="inline-flex items-center justify-center w-32 h-32 md:w-40 md:h-40 rounded-full bg-gradient-to-br from-red-500/20 to-pink-500/20 border border-red-500/30 mb-6 animate-pulse-slow">
                    <!-- Dynamic Icon based on error code -->
                    @if(View::hasSection('code') && trim(View::getSection('code')) == '404')
                        <i data-lucide="search-x" class="w-16 h-16 md:w-20 md:h-20 text-red-400"></i>
                    @elseif(View::hasSection('code') && trim(View::getSection('code')) == '419')
                        <i data-lucide="clock" class="w-16 h-16 md:w-20 md:h-20 text-yellow-400"></i>
                    @elseif(View::hasSection('code') && trim(View::getSection('code')) == '500')
                        <i data-lucide="server-crash" class="w-16 h-16 md:w-20 md:h-20 text-red-400"></i>
                    @elseif(View::hasSection('code') && trim(View::getSection('code')) == '403')
                        <i data-lucide="shield-x" class="w-16 h-16 md:w-20 md:h-20 text-orange-400"></i>
                    @else
                        <i data-lucide="alert-triangle" class="w-16 h-16 md:w-20 md:h-20 text-red-400"></i>
                    @endif
                </div>

                <h1 class="text-6xl md:text-8xl font-black text-transparent bg-clip-text bg-gradient-to-r from-red-400 via-pink-400 to-purple-400 mb-4 tracking-tight">
                    @yield('code', 'Error')
                </h1>
            </div>

            <!-- Error Message -->
            <div class="mb-10">
                <h2 class="text-2xl md:text-3xl font-bold text-white mb-4">
                    @yield('title', 'Something went wrong')
                </h2>
                <p class="text-gray-300 text-lg md:text-xl leading-relaxed max-w-lg mx-auto">
                    @yield('message', "We're experiencing some technical difficulties. Please try again later.")
                </p>
            </div>

            <!-- Action Buttons -->
            <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                <!-- Primary Action -->
                <button onclick="window.history.back()"
                        class="group inline-flex items-center gap-3 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-semibold px-8 py-4 rounded-2xl transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/25 focus:outline-none focus:ring-4 focus:ring-blue-500/20">
                    <i data-lucide="arrow-left" class="w-5 h-5 group-hover:-translate-x-1 transition-transform"></i>
                    <span>Go Back</span>
                </button>

                <!-- Secondary Action -->
                <a href="{{ url('/') }}"
                   class="group inline-flex items-center gap-3 bg-gray-800/80 hover:bg-gray-700/80 border border-gray-600 hover:border-gray-500 text-gray-200 hover:text-white font-semibold px-8 py-4 rounded-2xl transition-all duration-300 transform hover:-translate-y-1 hover:shadow-xl focus:outline-none focus:ring-4 focus:ring-gray-500/20">
                    <i data-lucide="home" class="w-5 h-5 group-hover:scale-110 transition-transform"></i>
                    <span>Go Home</span>
                </a>

                <!-- Refresh Action -->
                <button onclick="window.location.reload()"
                        class="group inline-flex items-center gap-3 bg-gray-800/50 hover:bg-gray-700/50 border border-gray-700 hover:border-gray-600 text-gray-300 hover:text-white font-medium px-6 py-3 rounded-xl transition-all duration-300 focus:outline-none focus:ring-4 focus:ring-gray-500/20 sm:mt-0 mt-2">
                    <i data-lucide="refresh-cw" class="w-4 h-4 group-hover:rotate-180 transition-transform duration-500"></i>
                    <span class="hidden sm:inline">Refresh</span>
                </button>
            </div>

            <!-- Help Section -->
            <div class="mt-12 pt-8 border-t border-gray-700/50">
                <p class="text-gray-400 text-sm mb-4">Need help?</p>
                <div class="flex flex-wrap justify-center gap-6 text-sm">
                    <a href="{{ url('/') }}" class="text-blue-400 hover:text-blue-300 transition-colors inline-flex items-center gap-2">
                        <i data-lucide="help-circle" class="w-4 h-4"></i>
                        Support Center
                    </a>
                    <a href="{{ url('/') }}" class="text-blue-400 hover:text-blue-300 transition-colors inline-flex items-center gap-2">
                        <i data-lucide="message-circle" class="w-4 h-4"></i>
                        Contact Us
                    </a>
                    <a href="{{ url('/') }}" class="text-blue-400 hover:text-blue-300 transition-colors inline-flex items-center gap-2">
                        <i data-lucide="book-open" class="w-4 h-4"></i>
                        Documentation
                    </a>
                </div>
            </div>

            <!-- Status Indicators -->
            <div class="mt-8 flex justify-center items-center gap-6 text-xs text-gray-500">
                <div class="flex items-center gap-2">
                    <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                    <span>System Status: Monitoring</span>
                </div>
                <div class="hidden sm:flex items-center gap-2">
                    <i data-lucide="shield-check" class="w-3 h-3 text-green-400"></i>
                    <span>Secure Connection</span>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="text-center mt-8 text-gray-500 text-sm animate-fade-in">
            <p>&copy; {{ date('Y') }} {{ $settings->site_name ?? config('app.name') }}. All rights reserved.</p>
        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Lucide icons
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }

            // Add some interactive effects
            const errorCard = document.querySelector('.glass-effect');
            if (errorCard) {
                errorCard.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-5px) scale(1.02)';
                });

                errorCard.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            }

            // Keyboard navigation
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    window.history.back();
                } else if (e.key === 'Home') {
                    window.location.href = '/';
                } else if (e.key === 'F5' || (e.ctrlKey && e.key === 'r')) {
                    e.preventDefault();
                    window.location.reload();
                }
            });
        });
    </script>

    <!-- CSRF Token Auto-Refresh Script -->
    <script src="{{ asset('js/csrf-token-refresh.js') }}"></script>
</body>
</html>

