<!DOCTYPE html>
<html lang="en" class="dark bg-gray-900">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title') - {{ $settings->site_name ?? config('app.name') }}</title>

    <!-- Favicon -->
    @if(isset($settings) && $settings->favicon)
        <link href="{{ asset('storage/app/public/'.$settings->favicon)}}" rel="icon" type="image/x-icon" />
    @endif

    <!-- Inter Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            200: '#c7d2fe',
                            300: '#a5b4fc',
                            400: '#818cf8',
                            500: '#6366f1',
                            600: '#4f46e5',
                            700: '#4338ca',
                            800: '#3730a3',
                            900: '#312e81',
                        },
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                        'fade-in': 'fadeIn 0.8s ease-out',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': { transform: 'translateY(0px)' },
                            '50%': { transform: 'translateY(-20px)' },
                        },
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' },
                        },
                    },
                }
            }
        }
    </script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <style>
        body {
            background-image:
                radial-gradient(at 40% 20%, hsla(228, 100%, 74%, 0.1) 0px, transparent 50%),
                radial-gradient(at 80% 0%, hsla(189, 100%, 56%, 0.1) 0px, transparent 50%),
                radial-gradient(at 0% 50%, hsla(355, 100%, 93%, 0.1) 0px, transparent 50%),
                radial-gradient(at 80% 50%, hsla(340, 100%, 76%, 0.1) 0px, transparent 50%),
                radial-gradient(at 0% 100%, hsla(22, 100%, 77%, 0.1) 0px, transparent 50%),
                radial-gradient(at 80% 100%, hsla(242, 100%, 70%, 0.1) 0px, transparent 50%),
                radial-gradient(at 0% 0%, hsla(343, 100%, 76%, 0.1) 0px, transparent 50%);
        }
        .glass-effect {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        .floating-shapes {
            position: absolute;
            inset: 0;
            overflow: hidden;
            pointer-events: none;
        }
        .floating-shape {
            position: absolute;
            opacity: 0.1;
            animation: float 8s ease-in-out infinite;
        }
        .floating-shape:nth-child(2) { animation-delay: -2s; }
        .floating-shape:nth-child(3) { animation-delay: -4s; }
    </style>
</head>

<body class="dark text-gray-100 bg-gray-900 min-h-screen flex items-center justify-center p-4 font-sans">
    <!-- Floating Background Shapes -->
    <div class="floating-shapes">
        <div class="floating-shape w-64 h-64 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full blur-3xl top-1/4 left-1/4"></div>
        <div class="floating-shape w-48 h-48 bg-gradient-to-r from-indigo-500 to-cyan-500 rounded-full blur-3xl top-3/4 right-1/4"></div>
        <div class="floating-shape w-32 h-32 bg-gradient-to-r from-pink-500 to-rose-500 rounded-full blur-3xl top-1/2 left-3/4"></div>
    </div>

    <!-- Main Error Container -->
    <div class="relative z-10 w-full max-w-md">
        <!-- Logo Section -->
        @if(isset($settings) && $settings->logo)
        <div class="flex justify-center mb-8 animate-fade-in">
            <div class="relative">
                <img src="{{ asset('storage/app/public/'.$settings->logo)}}"
                     class="h-12 w-auto brightness-110"
                     alt="{{ $settings->site_name ?? config('app.name') }}" />
                <div class="absolute inset-0 bg-gradient-to-r from-blue-500/20 to-indigo-500/20 rounded-lg blur-xl"></div>
            </div>
        </div>
        @endif

        <!-- Simple Error Card -->
        <div class="glass-effect rounded-3xl p-8 text-center animate-fade-in">
            <!-- Error Message -->
            <div class="mb-8">
                <h1 class="text-4xl md:text-5xl font-black text-transparent bg-clip-text bg-gradient-to-r from-red-400 via-pink-400 to-purple-400 mb-6 tracking-tight">
                    @yield('title', 'Error')
                </h1>

                <p class="text-gray-300 text-lg leading-relaxed">
                    @yield('message', "Something went wrong. Please try again.")
                </p>
            </div>

            <!-- Action Button -->
            <div class="mb-6">
                <button onclick="window.history.back()"
                        class="group inline-flex items-center gap-3 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-semibold px-8 py-4 rounded-2xl transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/25 focus:outline-none focus:ring-4 focus:ring-blue-500/20 w-full justify-center">
                    <i data-lucide="arrow-left" class="w-5 h-5 group-hover:-translate-x-1 transition-transform"></i>
                    <span>Go Back</span>
                </button>
            </div>

            <!-- Secondary Actions -->
            <div class="flex flex-col sm:flex-row gap-3 justify-center">
                <a href="{{ url('/') }}"
                   class="group inline-flex items-center gap-2 bg-gray-800/80 hover:bg-gray-700/80 border border-gray-600 hover:border-gray-500 text-gray-200 hover:text-white font-medium px-6 py-3 rounded-xl transition-all duration-300 focus:outline-none focus:ring-4 focus:ring-gray-500/20 justify-center">
                    <i data-lucide="home" class="w-4 h-4 group-hover:scale-110 transition-transform"></i>
                    <span>Home</span>
                </a>

                <button onclick="window.location.reload()"
                        class="group inline-flex items-center gap-2 bg-gray-800/50 hover:bg-gray-700/50 border border-gray-700 hover:border-gray-600 text-gray-300 hover:text-white font-medium px-6 py-3 rounded-xl transition-all duration-300 focus:outline-none focus:ring-4 focus:ring-gray-500/20 justify-center">
                    <i data-lucide="refresh-cw" class="w-4 h-4 group-hover:rotate-180 transition-transform duration-500"></i>
                    <span>Refresh</span>
                </button>
            </div>

            <!-- Status -->
            <div class="mt-8 pt-6 border-t border-gray-700/50">
                <div class="flex justify-center items-center gap-6 text-xs text-gray-500">
                    <div class="flex items-center gap-2">
                        <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                        <span>Status: Monitoring</span>
                    </div>
                    <div class="flex items-center gap-2">
                        <i data-lucide="shield-check" class="w-3 h-3 text-green-400"></i>
                        <span>Secure</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="text-center mt-6 text-gray-500 text-sm animate-fade-in">
            <p>&copy; {{ date('Y') }} {{ $settings->site_name ?? config('app.name') }}. All rights reserved.</p>
        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Lucide icons
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }

            // Keyboard navigation
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    window.history.back();
                } else if (e.key === 'Home') {
                    window.location.href = '/';
                } else if (e.key === 'F5' || (e.ctrlKey && e.key === 'r')) {
                    e.preventDefault();
                    window.location.reload();
                }
            });
        });
    </script>

    <!-- CSRF Token Auto-Refresh Script -->
    <script src="{{ asset('js/csrf-token-refresh.js') }}"></script>
</body>
</html>
