<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 ">Receipt Details - {{ $receipt->receipt_number }}</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="mb-3 row">
                    <div class="col-md-12">
                        <a href="{{ route('admin.receipts.pdf', $receipt->id) }}" class="btn btn-success me-2">
                            <i class="fas fa-download me-1"></i>Download PDF
                        </a>
                        <a href="{{ route('admin.receipts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i>Back to List
                        </a>
                    </div>
                </div>

                <!-- Receipt Summary -->
                <div class="mb-4 row">
                    <div class="col-md-12">
                        <div class="card bg-light">
                            <div class="card-body text-center">
                                <h2 class="text-primary mb-2">{{ $receipt->formatted_amount }}</h2>
                                <span class="badge badge-info fs-6 mb-2">{{ ucfirst($receipt->transaction_type) }}</span><br>
                                <span class="badge badge-{{ $receipt->template_type === 'bybit' ? 'dark' : ($receipt->template_type === 'binance' ? 'warning' : 'primary') }}">
                                    {{ ucfirst($receipt->template_type) }} Template
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mb-5 row">
                    <!-- Receipt Details -->
                    <div class="col-md-6">
                        <div class="card p-3 shadow h-100">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-user me-2"></i>User Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>Full Name:</strong></td>
                                        <td>{{ $receipt->user_name }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Email:</strong></td>
                                        <td>{{ $receipt->user_email }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Wallet Address:</strong></td>
                                        <td class="text-break">
                                            <code>{{ $receipt->wallet_address }}</code>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card p-3 shadow h-100">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-exchange-alt me-2"></i>Transaction Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>Receipt Number:</strong></td>
                                        <td><code>{{ $receipt->receipt_number }}</code></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Amount:</strong></td>
                                        <td>{{ $receipt->formatted_amount }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Cryptocurrency:</strong></td>
                                        <td>{{ $receipt->cryptocurrency }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Transaction Type:</strong></td>
                                        <td>
                                            <span class="badge badge-info">{{ ucfirst($receipt->transaction_type) }}</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Transaction Fee:</strong></td>
                                        <td>{{ $receipt->formatted_fee }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Transaction Date:</strong></td>
                                        <td>{{ \Carbon\Carbon::parse($receipt->transaction_date)->toDayDateTimeString() }}</td>
                                    </tr>
                                    @if($receipt->transaction_id)
                                    <tr>
                                        <td><strong>Transaction ID:</strong></td>
                                        <td class="text-break">
                                            <code>{{ $receipt->transaction_id }}</code>
                                        </td>
                                    </tr>
                                    @endif
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- System Information -->
                    <div class="col-md-6">
                        <div class="card p-3 shadow h-100">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-cog me-2"></i>System Information</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>Template Style:</strong></td>
                                        <td>
                                            <span class="badge badge-{{ $receipt->template_type === 'bybit' ? 'dark' : ($receipt->template_type === 'binance' ? 'warning' : 'primary') }}">
                                                {{ ucfirst($receipt->template_type) }}
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Status:</strong></td>
                                        <td>
                                            <span class="badge badge-success">{{ ucfirst($receipt->status) }}</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Created By:</strong></td>
                                        <td>{{ $receipt->creator->name ?? 'Admin' }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Created At:</strong></td>
                                        <td>{{ \Carbon\Carbon::parse($receipt->created_at)->toDayDateTimeString() }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Last Updated:</strong></td>
                                        <td>{{ \Carbon\Carbon::parse($receipt->updated_at)->toDayDateTimeString() }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Notes -->
                    @if($receipt->notes)
                    <div class="col-md-6">
                        <div class="card p-3 shadow h-100">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-sticky-note me-2"></i>Additional Notes</h5>
                            </div>
                            <div class="card-body">
                                <p class="mb-0">{{ $receipt->notes }}</p>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Receipt Preview -->
                <div class="mb-5 row">
                    <div class="col-md-12">
                        <div class="card p-3 shadow">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="mb-0"><i class="fas fa-eye me-2"></i>Receipt Preview</h5>
                                <div>
                                    <a href="{{ route('admin.receipts.pdf', $receipt->id) }}" class="btn btn-success btn-sm">
                                        <i class="fas fa-download me-1"></i>Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="receipt-preview border rounded p-3" style="background-color: #f8f9fa;">
                                    <div id="receipt-content">
                                        @include('admin.receipts.templates.' . $receipt->template_type, ['receipt' => $receipt])
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="mb-5 row">
                    <div class="col-md-12">
                        <div class="card p-3 shadow">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('admin.receipts.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left me-1"></i>Back to Receipt List
                                    </a>
                                    <div>
                                        <a href="{{ route('admin.receipts.pdf', $receipt->id) }}" class="btn btn-success me-2">
                                            <i class="fas fa-download me-1"></i>Download PDF
                                        </a>
                                        <button class="btn btn-danger" onclick="deleteReceipt({{ $receipt->id }})">
                                            <i class="fas fa-trash me-1"></i>Delete Receipt
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Receipt</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this receipt? This action cannot be undone.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <form id="deleteForm" method="POST" style="display: inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function deleteReceipt(id) {
            document.getElementById('deleteForm').action = '/admin/receipts/' + id;
            new bootstrap.Modal(document.getElementById('deleteModal')).show();
        }

        // Copy to clipboard functionality
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('Copied to clipboard!');
            });
        }

        // Add click-to-copy functionality to code elements
        document.addEventListener('DOMContentLoaded', function() {
            const codeElements = document.querySelectorAll('code');
            codeElements.forEach(function(element) {
                element.style.cursor = 'pointer';
                element.title = 'Click to copy';
                element.addEventListener('click', function() {
                    copyToClipboard(this.textContent);
                });
            });
        });
    </script>

    <style>
        .receipt-preview {
            max-height: 800px;
            overflow-y: auto;
        }

        .receipt-preview iframe {
            width: 100%;
            height: 600px;
            border: none;
        }

        code {
            cursor: pointer;
            transition: background-color 0.2s;
        }

        code:hover {
            background-color: #e9ecef !important;
        }

        .text-break {
            word-break: break-all;
        }

        /* Ensure black text on white cards */
        .card {
            color: #000 !important;
        }

        .card-body {
            color: #000 !important;
        }

        .table {
            color: #000 !important;
        }

        .table td, .table th {
            color: #000 !important;
        }

        .card-header {
            color: #000 !important;
        }

        .card-header h5 {
            color: #000 !important;
        }
    </style>
@endsection
