<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 ">Receipt Generator</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <!-- Stats Cards -->
                <div class="mb-4 row">
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-title">Total Receipts</h6>
                                        <h3 class="mb-0">{{ \App\Models\Receipt::count() }}</h3>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-receipt fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-title">Today's Receipts</h6>
                                        <h3 class="mb-0">{{ \App\Models\Receipt::whereDate('created_at', today())->count() }}</h3>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-calendar-day fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-title">Bybit Style</h6>
                                        <h3 class="mb-0">{{ \App\Models\Receipt::where('template_type', 'bybit')->count() }}</h3>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-chart-line fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-title">Binance Style</h6>
                                        <h3 class="mb-0">{{ \App\Models\Receipt::where('template_type', 'binance')->count() }}</h3>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-coins fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Generate New Receipt Button -->
                <div class="mb-3 row">
                    <div class="col-md-12">
                        <a href="{{ route('admin.receipts.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Generate New Receipt
                        </a>
                    </div>
                </div>

                <!-- Filters -->
                <div class="mb-3 row">
                    <div class="col card p-3 shadow">
                        <form method="GET" class="row g-3">
                            <div class="col-md-2">
                                <select name="template_type" class="form-control">
                                    <option value="">All Templates</option>
                                    <option value="bybit" {{ request('template_type') == 'bybit' ? 'selected' : '' }}>Bybit</option>
                                    <option value="binance" {{ request('template_type') == 'binance' ? 'selected' : '' }}>Binance</option>
                                    <option value="coinbase" {{ request('template_type') == 'coinbase' ? 'selected' : '' }}>Coinbase</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="transaction_type" class="form-control">
                                    <option value="">All Types</option>
                                    <option value="deposit" {{ request('transaction_type') == 'deposit' ? 'selected' : '' }}>Deposit</option>
                                    <option value="withdrawal" {{ request('transaction_type') == 'withdrawal' ? 'selected' : '' }}>Withdrawal</option>
                                    <option value="trade" {{ request('transaction_type') == 'trade' ? 'selected' : '' }}>Trade</option>
                                    <option value="transfer" {{ request('transaction_type') == 'transfer' ? 'selected' : '' }}>Transfer</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}" placeholder="From Date">
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}" placeholder="To Date">
                            </div>
                            <div class="col-md-2">
                                <input type="text" name="search" class="form-control" value="{{ request('search') }}" placeholder="Search...">
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-secondary">
                                    <i class="fas fa-search me-1"></i>Filter
                                </button>
                                <a href="{{ route('admin.receipts.index') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-times"></i>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="mb-5 row">
                    <div class="col card p-3 shadow ">
                        <div class="bs-example widget-shadow table-responsive" data-example-id="hoverable-table">
                            <span style="margin:3px;">
                                <table id="ShipTable" class="table table-hover ">
                                    <thead>
                                        <tr>
                                            <th>Receipt #</th>
                                            <th>User Name</th>
                                            <th>User Email</th>
                                            <th>Amount</th>
                                            <th>Transaction Type</th>
                                            <th>Template</th>
                                            <th>Status</th>
                                            <th>Date Created</th>
                                            <th>Option</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($receipts as $receipt)
                                        <tr>
                                            <td><strong>{{ $receipt->receipt_number }}</strong></td>
                                            <td>{{ $receipt->user_name }}</td>
                                            <td>{{ $receipt->user_email }}</td>
                                            <td>{{ $receipt->formatted_amount }}</td>
                                            <td>
                                                @switch($receipt->transaction_type)
                                                    @case('deposit')
                                                        <span class="badge badge-success">{{ ucfirst($receipt->transaction_type) }}</span>
                                                        @break
                                                    @case('withdrawal')
                                                        <span class="badge badge-warning">{{ ucfirst($receipt->transaction_type) }}</span>
                                                        @break
                                                    @case('trade')
                                                        <span class="badge badge-info">{{ ucfirst($receipt->transaction_type) }}</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">{{ ucfirst($receipt->transaction_type) }}</span>
                                                @endswitch
                                            </td>
                                            <td>
                                                @switch($receipt->template_type)
                                                    @case('bybit')
                                                        <span class="badge badge-dark">Bybit</span>
                                                        @break
                                                    @case('binance')
                                                        <span class="badge badge-warning">Binance</span>
                                                        @break
                                                    @case('coinbase')
                                                        <span class="badge badge-primary">Coinbase</span>
                                                        @break
                                                @endswitch
                                            </td>
                                            <td>
                                                <span class="badge badge-success">{{ ucfirst($receipt->status) }}</span>
                                            </td>
                                            <td>{{ \Carbon\Carbon::parse($receipt->created_at)->toDayDateTimeString() }}</td>
                                            <td>
                                                <a href="{{ route('admin.receipts.show', $receipt->id) }}" class="m-1 btn btn-info btn-sm">
                                                    <i class="fa fa-eye"></i> View
                                                </a>
                                                <a href="{{ route('admin.receipts.pdf', $receipt->id) }}" class="m-1 btn btn-success btn-sm">
                                                    <i class="fa fa-download"></i> PDF
                                                </a>
                                                <button class="m-1 btn btn-danger btn-sm" onclick="deleteReceipt({{ $receipt->id }})">
                                                    <i class="fa fa-trash"></i> Delete
                                                </button>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="9" class="text-center py-4">
                                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                                <p class="text-muted">No receipts found</p>
                                                <a href="{{ route('admin.receipts.create') }}" class="btn btn-primary">
                                                    Generate Your First Receipt
                                                </a>
                                            </td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Pagination -->
                @if($receipts->hasPages())
                <div class="d-flex justify-content-center">
                    {{ $receipts->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Receipt</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this receipt? This action cannot be undone.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <form id="deleteForm" method="POST" style="display: inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
    function deleteReceipt(id) {
        document.getElementById('deleteForm').action = '/admin/receipts/' + id;
        new bootstrap.Modal(document.getElementById('deleteModal')).show();
    }
    </script>
@endsection
