<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 ">Generate New Receipt</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="mb-3 row">
                    <div class="col-md-12">
                        <a href="{{ route('admin.receipts.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i>Back to Receipts
                        </a>
                    </div>
                </div>

                <div class="mb-5 row">
                    <div class="col card p-3 shadow ">
                        <form action="{{ route('admin.receipts.store') }}" method="POST">
                            @csrf

                            <div class="row">
                                <!-- User Information -->
                                <div class="col-md-6">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5 class="mb-0"><i class="fas fa-user me-2"></i>User Information</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="user_name" class="form-label">Full Name *</label>
                                                <input type="text" class="form-control @error('user_name') is-invalid @enderror"
                                                       id="user_name" name="user_name" value="{{ old('user_name') }}" required>
                                                @error('user_name')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label for="user_email" class="form-label">Email Address *</label>
                                                <input type="email" class="form-control @error('user_email') is-invalid @enderror"
                                                       id="user_email" name="user_email" value="{{ old('user_email') }}" required>
                                                @error('user_email')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label for="wallet_address" class="form-label">Wallet Address *</label>
                                                <input type="text" class="form-control @error('wallet_address') is-invalid @enderror"
                                                       id="wallet_address" name="wallet_address" value="{{ old('wallet_address') }}" required>
                                                @error('wallet_address')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Transaction Information -->
                                <div class="col-md-6">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5 class="mb-0"><i class="fas fa-exchange-alt me-2"></i>Transaction Information</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="amount" class="form-label">Amount *</label>
                                                <input type="number" step="0.00000001" class="form-control @error('amount') is-invalid @enderror"
                                                       id="amount" name="amount" value="{{ old('amount') }}" required>
                                                @error('amount')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label for="cryptocurrency" class="form-label">Cryptocurrency *</label>
                                                <select class="form-control @error('cryptocurrency') is-invalid @enderror"
                                                        id="cryptocurrency" name="cryptocurrency" required>
                                                    <option value="">Select Cryptocurrency</option>
                                                    <option value="BTC" {{ old('cryptocurrency') == 'BTC' ? 'selected' : '' }}>Bitcoin (BTC)</option>
                                                    <option value="ETH" {{ old('cryptocurrency') == 'ETH' ? 'selected' : '' }}>Ethereum (ETH)</option>
                                                    <option value="USDT" {{ old('cryptocurrency') == 'USDT' ? 'selected' : '' }}>Tether (USDT)</option>
                                                    <option value="USDC" {{ old('cryptocurrency') == 'USDC' ? 'selected' : '' }}>USD Coin (USDC)</option>
                                                    <option value="BNB" {{ old('cryptocurrency') == 'BNB' ? 'selected' : '' }}>Binance Coin (BNB)</option>
                                                    <option value="ADA" {{ old('cryptocurrency') == 'ADA' ? 'selected' : '' }}>Cardano (ADA)</option>
                                                    <option value="SOL" {{ old('cryptocurrency') == 'SOL' ? 'selected' : '' }}>Solana (SOL)</option>
                                                    <option value="DOT" {{ old('cryptocurrency') == 'DOT' ? 'selected' : '' }}>Polkadot (DOT)</option>
                                                    <option value="DOGE" {{ old('cryptocurrency') == 'DOGE' ? 'selected' : '' }}>Dogecoin (DOGE)</option>
                                                    <option value="LTC" {{ old('cryptocurrency') == 'LTC' ? 'selected' : '' }}>Litecoin (LTC)</option>
                                                </select>
                                                @error('cryptocurrency')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label for="transaction_type" class="form-label">Transaction Type *</label>
                                                <select class="form-control @error('transaction_type') is-invalid @enderror"
                                                        id="transaction_type" name="transaction_type" required>
                                                    <option value="">Select Transaction Type</option>
                                                    <option value="deposit" {{ old('transaction_type') == 'deposit' ? 'selected' : '' }}>Deposit</option>
                                                    <option value="withdrawal" {{ old('transaction_type') == 'withdrawal' ? 'selected' : '' }}>Withdrawal</option>
                                                    <option value="trade" {{ old('transaction_type') == 'trade' ? 'selected' : '' }}>Trade</option>
                                                    <option value="transfer" {{ old('transaction_type') == 'transfer' ? 'selected' : '' }}>Transfer</option>
                                                    <option value="spot_trading" {{ old('transaction_type') == 'spot_trading' ? 'selected' : '' }}>Spot Trading</option>
                                                    <option value="futures_trading" {{ old('transaction_type') == 'futures_trading' ? 'selected' : '' }}>Futures Trading</option>
                                                </select>
                                                @error('transaction_type')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Date and Additional Information -->
                                <div class="col-md-6">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5 class="mb-0"><i class="fas fa-calendar me-2"></i>Date & Additional Information</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="transaction_date" class="form-label">Transaction Date *</label>
                                                <input type="datetime-local" class="form-control @error('transaction_date') is-invalid @enderror"
                                                       id="transaction_date" name="transaction_date"
                                                       value="{{ old('transaction_date', date('Y-m-d\TH:i')) }}" required>
                                                @error('transaction_date')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label for="transaction_fee" class="form-label">Transaction Fee</label>
                                                <input type="number" step="0.00000001" class="form-control @error('transaction_fee') is-invalid @enderror"
                                                       id="transaction_fee" name="transaction_fee" value="{{ old('transaction_fee', '0') }}">
                                                @error('transaction_fee')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label for="transaction_id" class="form-label">Transaction ID/Hash</label>
                                                <input type="text" class="form-control @error('transaction_id') is-invalid @enderror"
                                                       id="transaction_id" name="transaction_id" value="{{ old('transaction_id') }}"
                                                       placeholder="Optional">
                                                @error('transaction_id')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Template Selection -->
                                <div class="col-md-6">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5 class="mb-0"><i class="fas fa-palette me-2"></i>Receipt Template</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="template_type" class="form-label">Select Template Style *</label>
                                                <select class="form-control @error('template_type') is-invalid @enderror"
                                                        id="template_type" name="template_type" required>
                                                    <option value="">Choose Template</option>
                                                    <option value="bybit" {{ old('template_type') == 'bybit' ? 'selected' : '' }}>
                                                        Bybit Style (Dark Orange Theme)
                                                    </option>
                                                    <option value="binance" {{ old('template_type') == 'binance' ? 'selected' : '' }}>
                                                        Binance Style (Yellow Gold Theme)
                                                    </option>
                                                    <option value="coinbase" {{ old('template_type') == 'coinbase' ? 'selected' : '' }}>
                                                        Coinbase Style (Blue Professional Theme)
                                                    </option>
                                                </select>
                                                @error('template_type')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <!-- Template Preview -->
                                            <div id="templatePreview" class="mt-3" style="display: none;">
                                                <div class="alert alert-info">
                                                    <strong>Template Preview:</strong>
                                                    <span id="previewText"></span>
                                                </div>
                                            </div>

                                            <div class="mb-3">
                                                <label for="notes" class="form-label">Additional Notes</label>
                                                <textarea class="form-control @error('notes') is-invalid @enderror"
                                                          id="notes" name="notes" rows="3"
                                                          placeholder="Any additional information for the receipt">{{ old('notes') }}</textarea>
                                                @error('notes')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between">
                                                <a href="{{ route('admin.receipts.index') }}" class="btn btn-secondary">
                                                    <i class="fas fa-times me-1"></i>Cancel
                                                </a>
                                                <div>
                                                    <button type="submit" class="btn btn-primary">
                                                        <i class="fas fa-plus me-1"></i>Generate Receipt
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('template_type').addEventListener('change', function() {
            const previewDiv = document.getElementById('templatePreview');
            const previewText = document.getElementById('previewText');
            const value = this.value;

            if (value) {
                previewDiv.style.display = 'block';
                switch(value) {
                    case 'bybit':
                        previewText.textContent = 'Professional dark theme with orange accents, similar to Bybit exchange';
                        break;
                    case 'binance':
                        previewText.textContent = 'Clean yellow and gold theme, similar to Binance exchange';
                        break;
                    case 'coinbase':
                        previewText.textContent = 'Modern blue professional theme, similar to Coinbase exchange';
                        break;
                }
            } else {
                previewDiv.style.display = 'none';
            }
        });

        // Auto-generate transaction hash
        document.addEventListener('DOMContentLoaded', function() {
            const transactionIdField = document.getElementById('transaction_id');
            if (!transactionIdField.value) {
                transactionIdField.value = generateTransactionHash();
            }
        });

        function generateTransactionHash() {
            const chars = '0123456789abcdef';
            let result = '0x';
            for (let i = 0; i < 64; i++) {
                result += chars[Math.floor(Math.random() * chars.length)];
            }
            return result;
        }
    </script>
@endsection
