<?php

return [

    /*
    |--------------------------------------------------------------------------
    | CSRF Token Auto-Refresh Settings
    |--------------------------------------------------------------------------
    |
    | These settings control the automatic CSRF token refresh functionality
    | to prevent "Page Expired" (419) errors when users stay on pages
    | for extended periods.
    |
    */

    /*
    | Refresh Interval (in minutes)
    | How often the CSRF token should be refreshed automatically.
    | Should be less than session lifetime to prevent expiration.
    */
    'refresh_interval' => env('CSRF_REFRESH_INTERVAL', 60),

    /*
    | Warning Time (in minutes)
    | How many minutes before session expiry to warn the user.
    */
    'warning_time' => env('CSRF_WARNING_TIME', 10),

    /*
    | Max Retry Attempts
    | How many times to retry CSRF token refresh if it fails.
    */
    'max_retries' => env('CSRF_MAX_RETRIES', 3),

    /*
    | Enable Auto-Refresh
    | Whether to enable automatic CSRF token refresh.
    */
    'auto_refresh_enabled' => env('CSRF_AUTO_REFRESH', true),

    /*
    | Enable Retry on 419
    | Whether to automatically retry form submissions when CSRF token expires.
    */
    'retry_on_419' => env('CSRF_RETRY_ON_419', true),

    /*
    | Show User Warnings
    | Whether to show warnings to users before session expires.
    */
    'show_warnings' => env('CSRF_SHOW_WARNINGS', true),

];
